<?php

namespace Mtc\ContentManager\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Mtc\ContentManager\Contracts\MediaUse;
use Mtc\ContentManager\Facades\Media;

class RemoveMediaUseOutdatedSizes implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    public function __construct(protected Collection $chunk, protected array $sizes_to_remove)
    {
        //
    }

    public function handle()
    {
        $this->chunk->each(function (MediaUse $mediaUse) {
            foreach ($this->sizes_to_remove as $dimensions) {
                $dimensions = explode('x', $dimensions);
                Media::removeMediaUseSize($mediaUse, $dimensions[0], $dimensions[1]);
            }
        });
    }
}
