# Core Shop Analytics Stats

This package works as a patch for sites that require Google Analytics
in dashboard stats. The legacy version is broken due to Google Analytics 4 replacing Universal Analytics.

This integration relies on using Google Analytics Data API (GA4) which is the main
supported integration during the creation of the package. https://developers.google.com/analytics/devguides/reporting/data/v1

Please note: the properties for "ga:visitors" and "ga:visits" are no longer available in GA4, these were replaced with the relevant properties in GA4: https://developers.google.com/analytics/devguides/reporting/data/v1/api-schema

**GA4 Active users:** The number of distinct users who visited your site or app.
>ga:visitors -> activeUsers

**GA4 Views:** The number of app screens or web pages your users viewed. Repeated views of a single page or screen are counted. (screen_view + page_view events).

>ga:visits -> screenPageViews

## Installation & Setup

### Step 1. Install package
```
composer require mtcmedia/core-analytics-stats
```

### Step 2. Add service account to the Google Analytics 4 account
Use this email address `starting-account-x85rhmjs69a@ga4-service-acco-1698130703051.iam.gserviceaccount.com` to add a user to the Google Analytics 4 property (client account) you want to access via the Google Analytics Data API v1. For this only Viewer permissions are needed.
(The Google service account was set up using this account: **marketing@mtcmedia.co.uk**)

Speak with the marketing team in case you don't have access to the client's GA4 account.

Make a note of the GA4 `Property ID` as you'll need this later.

### Step 3. Update the dashboards stats
Use the `property ID` in the code when calling the stats and update the first 4 entries
for the Visitor stats by replacing local function calls with $calls on $analytics object.

**Please Note**: the basket visitor count method has been renamed to **getTotalVisitorsToPage()**

```php
$analytics = (new \Mtc\AnalyticsStats\Stats('PROPERTY_ID'));
$dashboardData[0]['Number of Visits'] = $numVisits = $analytics->getTotalVisits(date_dmy_to_db($_REQUEST['start-date']), date_dmy_to_db($_REQUEST['end-date']));
$dashboardData[0]['Number of Unique Visitors'] = $uniqueVisitors = $analytics->getTotalVisitors(date_dmy_to_db($_REQUEST['start-date']), date_dmy_to_db($_REQUEST['end-date']));
$dashboardData[0]['Conversion Rate %'] = $conversionRate = $analytics->getConversionRate(date_dmy_to_db($_REQUEST['start-date']), date_dmy_to_db($_REQUEST['end-date']), function ($startDate, $endDate) {
// Returns total orders during the specified period
});
$dashboardData[0]['Visitors to Basket Page'] = $visitorsBasket = $analytics->getTotalVisitorsToPage(date_dmy_to_db($_REQUEST['start-date']), date_dmy_to_db($_REQUEST['end-date']), '/shop/checkout/basket.php');
```