<?php

namespace Mtc\Core\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Event;
use Mtc\Core\Http\Controllers\Controller;

/**
 * Class AdminController
 *
 * @package Mtc\Core\Http\Controllers\Admin
 */
class AdminController extends Controller
{
    /**
     * Dashboard index page
     *
     * @param Request $request
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    public function index(Request $request)
    {
        if ($request->input('access') === 'none') {
            // put up a 403 because the client would have landed here
            // with the above params set only if he was doing something forbidden
            // based on admin area auth so that ajax scripts can handle accordingly
            header("HTTP/1.0 403 Forbidden");
            $messages = [
                [
                    'type' => 'error',
                    'content' => 'You do not have permission to view that page.'
                ]
            ];
        }

        $graphs = $numeric_stats = [];
        if (config('settings.ADVANCED_STATS_ENABLED') === true || config('settings.GRAPH_STATS_ENABLED') === true) {
            $stats = collect(Event::dispatch('Admin::dashboardStats'))
                ->flatten(1);
            $graphs = $stats->where('type', 'graph');
            $numeric_stats = $stats->where('type', 'numeric');
            $quick_stats = $stats->where('type', 'quick_stats')
                ->take(4);
        }

        return view('admin::dashboard', [
            'messages' => $messages ?? null,
            'graphs' => $graphs,
            'numeric_stats' => $numeric_stats,
            'dashboard_events' => Event::dispatch("admin.dashboard"),
            'start_date' => $request->input('start_date', date('d/m/Y')),
            'end_date' => $request->input('end_date', date('d/m/Y')),
            'quick_stats' => $quick_stats ?? null,
            'admin_section_class' => 'dashboard',
            'graph_columns' => count($graphs) % 2 == 0 ? 2 : 3,
            'table_columns' => count($numeric_stats) % 2 == 0 ? 2 : 3

        ]);
    }

    /**
     * AWStats panel pass-through for admin panel
     *
     * @param Request $request
     * @return bool|mixed|string
     */
    public function stats(Request $request)
    {
        $user = config('app.awstats.user');
        $pass = config('app.awstats.password');
        $domain = config('app.awstats.domain');
        $ssl = config('app.awstats.ssl');

        if (blank($ssl)) {
            $ssl = $request->server('HTTPS') ? 1 : 0;
        }

        if (empty($user) || empty($pass) || empty($domain)) {
            die('Please define credentials in .env file');
        }

        $dynamic_images = false;
        $image_directory = 'http://awstats.mtcserver4.com/awstats_images/';

        //lame attempt to combat referrer spam
        $spam_words = ['mortgage', 'sex', 'porn', 'cock', 'slut', 'facial', 'loving', 'gay', '.ro'];

        $requesting_image = (strpos($request->server('QUERY_STRING'), '.png') === false) ? false : true;

        if ($dynamic_images && $requesting_image) { //it's a .png file...
            if (!is_dir($image_directory)) {
                exit;
            }
            $fileQuery = $request->server('QUERY_STRING');
        } elseif (empty($request->server('QUERY_STRING'))) {//probably first time to access page...
            $fileQuery = "awstats.pl?config=$domain&ssl=$ssl";
        } else { //otherwise, all other accesses
            $fileQuery = 'awstats.pl?' . $request->server('QUERY_STRING');
        }

        $file = file_get_contents("http://$user:" . urlencode($pass) . "@localhost:2082/" . $fileQuery);

        //check again to see if it was a .png file
        //if it's not, replace the links
        if (!$requesting_image) {
            $file = str_replace('awstats.pl', basename($request->getPathInfo()), $file);

            if ($dynamic_images) {
                $imgsrc_search = '="/images';
                $imgsrc_replace = '="' . basename($request->getPathInfo()) . '?images';
            } else {
                $imgsrc_search = 'src="/images/awstats/';
                $imgsrc_replace = 'src="' . $image_directory;
            }

            $file = str_replace($imgsrc_search, $imgsrc_replace, $file);
            $file = str_replace($spam_words, 'SPAM', $file);
        } else { //if it is a png, output appropriate header
            header("Content-type: image/png");
        }

        return $file;
    }

    /**
     * Display server info to developers
     *
     * @return void
     */
    public function phpInfo()
    {
        phpinfo();
    }
}
