<?php

namespace Mtc\Core\Http\Controllers;

use Illuminate\Http\Request;
use Mtc\Core\UkPostcode;

/**
 * Class AddressFinderController
 *
 * Implements mtc Postcode Address Finder backend functionality
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class AddressFinderController extends Controller
{
    /**
     * Search for address in Postcode finder
     *
     * @param Request $request
     * @return array|string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    public function search(Request $request)
    {
        if ($request->input('postcode')) {
            $postcode = UkPostcode::normalize($request->input('postcode'));
            if (UkPostcode::validates($postcode)) {
                // Only proceed with search if we have a valid postcode
                $address_list = UkPostcode::retrievePAFAddresses($postcode);
                if (!empty($address_list)) {
                    array_unshift($address_list, "Select Your Address");
                    $response_status = 'ok';
                } else {
                    $message = 'Your Postcode could not be found';
                    $response_status = 'not_found';
                    $failed = true;
                }
            } else {
                $response_status = 'invalid';
                $message = 'Please enter a valid postcode';
                $failed = true;
            }
        } else {
            $response_status = 'invalid';
            $message = 'Please enter a valid postcode';
            $failed = true;
        }

        if ($request->wantsJson()) {
            return [
                'status' => $response_status,
                'addresses' => $address_list ?? [ $message ]
            ];
        }

        return template('address_finder_list.twig', [
            'address_list' => $address_list,
            'message' => $message,
            'failed' => $failed,
        ]);
    }
}
