<?php

namespace Mtc\Core\Http\Controllers\Admin;

use Mtc\Core\Http\Controllers\Controller;

/**
 * EmailsController
 *
 * Lists all Core Email templates as examples.
 */
class EmailsController extends Controller
{
    /**
     * Displays Core Emails examples
     *
     * @return mixed
     */
    public function index()
    {
        $this->page_meta['title'] = 'Core Emails';

        $emails = config('mail.demo_emails');

        // get email contents
        foreach ($emails as $email => $email_values) {
            $emails[$email]['content'] = template($email_values['file_path'], $emails[$email]['dummy_values']);
        }

        $header_style = 'font-family: Helvetica,Arial,sans-serif;text-align:center;margin:40px 0 0;font-size:30px;';
        $twig_params = [
            'page_meta' => $this->page_meta,
            'header_style' => $header_style,
            'emails' => $emails,
        ];

        return template('admin/emails/index.twig', $twig_params);
    }
}
