<?php

namespace Mtc\Core\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Mtc\Core\Node;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

/**
 * Class NodeController
 * Deals with url routing from database nodes
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class NodeController extends Controller
{
    /**
     * Wildcard search
     * We didn't hit any existing route so we try to match against database
     * First we do a full url match from the page request (e.g. '/denim-jeans/')
     * If an exact match is not found we try finding a partial match (e.g. '/denim-jeans/*')
     * If partial match is found we also need to verify that this route can have partial match from model
     *
     * @throws NotFoundHttpException
     */
    public function index(Request $request)
    {
        $full_match = Node::query()
            ->with('nodeable')
            ->where('url', $request->getPathInfo())
            ->first();

        if ($full_match) {
            return $full_match->nodeable->loadController($request);
        }

        $sanitized_path = DB::getPdo()->quote($request->getPathInfo());
        $partial_match = Node::query()
            ->with('nodeable')
            ->whereRaw(DB::raw("{$sanitized_path} LIKE CONCAT(`url`, \"%\")"))
            ->first();

        if ($partial_match && $partial_match->nodeable->allowPartialMatch()) {
            return $partial_match->nodeable->loadController($request);
        }

        throw new NotFoundHttpException();
    }
}
