<?php

namespace Mtc\Core\Admin;

/**
 * Class Role
 * Admin user Role model
 * Adds global scope that narrows roles down to admin only
 *
 * @package Mtc\Core\Admin
 */
class Role extends \Spatie\Permission\Models\Role
{
    /**
     * Name of the role group for admin users
     */
    const ADMIN_GROUP_NAME = 'admin';

    /**
     * Extend model booting
     */
    protected static function boot()
    {
        parent::boot();

        self::addGlobalScope(function ($query) {
            return $query->where('group', self::ADMIN_GROUP_NAME);
        });

        self::creating(function ($role) {
            $role->group = self::ADMIN_GROUP_NAME;
        });

        self::saved(function ($role) {
            Menu::invalidateMenuCache();
        });
    }
}