<?php

namespace Mtc\Core\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\Shop\Brand;

/**
 * Class SeoBrandController
 *
 * @package Mtc\Core\Http\Controllers\Admin
 */
class SeoBrandController extends Controller
{
    /**
     * Displays Seo Page list
     *
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    public function index()
    {
        $this->page_meta['title'] = 'Manage SEO Brands';

        return template('admin/seo/brands/index.twig', [
            'page_meta' => $this->page_meta,
            'brands' => Brand::query()->latest('id')->get(),
        ]);
    }

    /**
     * Render view for editing a page
     *
     * @param Brand $brand
     * @return string
     */
    public function edit(Brand $brand)
    {
        $this->page_meta['title'] = 'Edit Seo Brand';
        return template('admin/seo/brands/edit.twig', [
            'page_meta' => $this->page_meta,
            'brand' => $brand,
        ]);
    }

    /**
     * Update a seo page
     *
     * @param Request $request
     * @param Brand $brand
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(Request $request, Brand $brand)
    {
        $validated = $this->validate($request, [
            'seo_title' => 'required',
            'seo_description' => 'present',
        ]);

        $brand->fill($validated)->save();
        session()->flash('success', 'Brand entry Updated');
        return redirect(route('seo.brands.index'));
    }

}
