<?php

namespace Mtc\Core\Seeds;

use Mtc\Core\Seo\Setting;
use Illuminate\Database\Seeder;

/**
 * Class SeoSettingSeeder
 */
class SeoSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->getData())
            ->each(function ($setting) {
                Setting::query()
                    ->updateOrCreate([
                        'key' => $setting['key']
                    ], $setting);
            });
    }

    /**
     * seed data
     *
     * @return array
     */
    protected function getData()
    {
        return [
            [
                'key' => 'GA_USERAGENT',
                'value' => '',
                'description' => 'Google Analytics User Agent. Fill this in to enable general GA tracking as well as GA e-commerce tracking.'
            ],
            [
                'key' => 'GTM_ID',
                'value' => '',
                'description' => 'Google Tag Manager ID. Used INSTEAD of GA_USERAGENT'
            ],
            [
                'key' => 'GOOGLE_ANALYTICS_PROFILE_ID',
                'value' => '',
                'description' => ''
            ],
            [
                'key' => 'HOTJAR_TRACKING_CODE',
                'value' => '',
                'description' => 'Code used to activate hotjar tracking on a site.'
            ],
        ];
    }
}
