<?php

namespace Mtc\Core\Gate;

use Illuminate\Support\Facades\App;
use Mtc\Core\Admin\Menu;
use Mtc\Core\Admin\User;
use Mtc\Core\Http\Controllers\Auth\ForgotPasswordController;
use Mtc\Core\Http\Controllers\Auth\LoginController;
use Mtc\Core\Http\Controllers\Auth\ResetPasswordController;
use Mtc\Core\Http\Controllers\Controller;

/**
 * Class Auth
 * Gate that checks admin users permissions to view this page
 *
 * @package Mtc\Core\Gate
 */
class Auth
{
    /**
     * Check the Admin authorization and access
     *
     * @param Controller|null $controller
     * @return User|boolean
     */
    public static function loadUser($controller = null)
    {
        $twig = App::make('twig');

        // skip if not admin url
        // This should be a middleware but fixed for now
        if (stripos(request()->getRequestUri(), 'admin') === false) {
            return false;
        }

        /** @var User $admin */
        $admin = User::query()->find($_SESSION[User::SESSION_KEY]);

        if (self::unauthorizedAdminAccess($controller)) {
            header('Location: /admin/login?redirect=' . urlencode(request()->getRequestUri()));
            exit;
        }

        if ($admin) {
            if (!$admin->canAccessUrl(request()->getPathInfo())) {
                header("Location: /admin/index.php?access=none");
                exit;
            }

            $twig->addGlobal('admin_id', $admin->id);
            $twig->addGlobal('admin_user', $admin);
            $twig->addGlobal('cms_tree', Menu::showCMSTree($admin));
            $twig->addGlobal('admin_menu', Menu::generateMenuTree($admin));

            return $admin;
        }
    }

    /**
     * Check if this user is authorized or not
     *
     * @return bool
     */
    protected static function unauthorizedAdminAccess($controller)
    {
        // Check if admin is set
        if (!empty($_SESSION['adminId'])) {
            return false;
        }

        // No user info and is not trying to access controller
        if (!is_object($controller)) {
            return true;
        }

        // Admin still can have access to LoginController
        return !in_array(get_class($controller), [
            LoginController::class,
            ForgotPasswordController::class,
            ResetPasswordController::class,
        ]);
    }
}