<?php

namespace Mtc\Core\Models;

use Illuminate\Database\Eloquent\Model as IlluminateModel;

/**
 * Migration Model
 *     Model to handle checks for the migrations
 *
 * @package Mtc\Core\Models
 * @author   Kathryn Reeve <kathryn.reeve@mtcmedia.co.uk>
 * @copyright mtc. http://www.mtcmedia.co.uk/
 * @version   2016-09-30
 */
class Migration extends IlluminateModel
{
    /**
     * @inheritDoc
     */
    protected $table = 'migrations';

    /**
     * turn off updated at, we're only interested in create_at
     *
     * @return null
     */
    public function getUpdatedAtColumn()
    {
        return null;
    }

    /**
     * turn off updated at, we're only interested in create_at
     *
     * @return Migration
     */
    public function setUpdatedAt($value)
    {
        return $this;
    }
}