<?php

namespace Mtc\Core;

use Illuminate\Http\Request;

/**
 * Class Captcha
 *
 * @package Mtc\Core
 */
class Captcha
{
    /**
     * @var Request
     */
    protected $request;

    /**
     * Captcha constructor.
     *
     * @param Request $request
     */
    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    /**
     * Validate the captcha request
     *
     * @return bool
     */
    public function validate()
    {
        if ($this->request->has('g-recaptcha-response') === false) {
            return true;
        }

        $params = [
            'secret' => RECAPTCHA_SECRET,
            'response' => $this->request->get('g-recaptcha-response'),
            'remoteip' => $this->request->ip(),
        ];

        $response = json_decode(file_get_contents('https://www.google.com/recaptcha/api/siteverify?' . http_build_query($params)));
        return $response->success == true && $response->score > 0.5;
    }
}