<?php

namespace Mtc\Core\Seo;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Page
 *
 * @package Mtc\Core\Seo
 */
class Page extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'seo_pages';

    /**
     * Mass assignable variables
     *
     * @var array
     */
    protected $fillable = [
        'path',
        'title',
        'description'
    ];

    /**
     * Hide columns from being visible
     *
     * @var array
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];
    /**
     * Query for export
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public static function exportQuery()
    {
        return self::query()
            ->select([
                'path',
                'title',
                'description',
            ])
            ->orderBy('path');
    }
}
