<?php

namespace Mtc\Core\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Filesystem\Filesystem;
use RuntimeException;

/**
 * Class TemplateClearCommand
 *
 * @package Mtc\Core\Console\Commands
 */
class TemplateClearCommand extends Command
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $name = 'template:clear';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clear all cached template files';

    /**
     * The filesystem instance.
     *
     * @var \Illuminate\Filesystem\Filesystem
     */
    protected $files;

    /**
     * Create a new config clear command instance.
     *
     * @param \Illuminate\Filesystem\Filesystem $files
     * @return void
     */
    public function __construct(Filesystem $files)
    {
        parent::__construct();
        $this->files = $files;
    }

    /**
     * Execute the console command.
     *
     * @return void
     *
     * @throws \RuntimeException
     */
    public function handle()
    {
        $path = $this->laravel['config']['view.compiled'];
        if (!$path) {
            throw new RuntimeException('View path not found.');
        }
        foreach ($this->files->glob("{$path}/*") as $view) {
            $this->files->isDirectory($view) ? $this->files->deleteDirectory($view) : $this->files->delete($view);
        }
        $this->info('Compiled views cleared!');
    }
}