<?php

namespace Mtc\Core\Seeds;

use Illuminate\Database\Seeder;

class CurrencySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (\Mtc\Core\Currency::query()->count() > 0) {
            return;
        }

        collect(self::getData())
            ->each(function ($currency) {
                \Mtc\Core\Currency::query()
                    ->create($currency);
            });
    }

    /**
     * Get the currency list to seed
     *
     * @return array
     */
    protected static function getData()
    {
        return [
            [
                'currency' => 'GBP',
                'ratio' => 1,
                'symbol' => '£',
                'name' => 'British Pound ',
                'enabled' => 1,
            ],
            [
                'currency' => 'EUR',
                'ratio' => 1.1261,
                'symbol' => '€',
                'name' => 'Euro',
                'enabled' => 1,
            ],
            [
                'currency' => 'USD',
                'ratio' => 1.4036,
                'symbol' => '$',
                'name' => 'US Dollar',
                'enabled' => 1,
            ],
            [
                'currency' => 'JPY',
                'ratio' => 149.0265,
                'name' => 'Japanese Yen',
            ],
            [
                'currency' => 'BGN',
                'ratio' => 2.2024,
                'name' => 'Bulgarian Lev',
            ],
            [
                'currency' => 'CZK',
                'ratio' => 28.5351,
                'name' => 'Czech Koruna',
            ],
            [
                'currency' => 'DKK',
                'ratio' => 8.3872,
                'name' => 'Danish Krone',
            ],
            [
                'currency' => 'HUF',
                'ratio' => 350.5287,
                'name' => 'Hungarian Forint',
            ],
            [
                'currency' => 'PLN',
                'ratio' => 4.6842,
                'name' => 'Polish Zloty',
            ],
            [
                'currency' => 'RON',
                'ratio' => 5.2504,
                'name' => 'Romanian Leu',
            ],
            [
                'currency' => 'SEK',
                'ratio' => 11.164,
                'name' => 'Swedish Krona',
            ],
            [
                'currency' => 'CHF',
                'ratio' => 1.2974,
                'name' => 'Swiss Franc',
            ],
            [
                'currency' => 'ISK',
                'ratio' => 140.9862,
                'name' => 'Icelandic Krona',
            ],
            [
                'currency' => 'NOK',
                'ratio' => 10.9017,
                'name' => 'Norwegian Krone',
            ],
            [
                'currency' => 'HRK',
                'ratio' => 8.3758,
                'name' => 'Croatian Kuna',
            ],
            [
                'currency' => 'RUB',
                'ratio' => 79.1509,
                'name' => 'Russian Ruble',
            ],
            [
                'currency' => 'TRY',
                'ratio' => 5.2683,
                'name' => 'Turkish Lira',
            ],
            [
                'currency' => 'AUD',
                'ratio' => 1.7674,
                'name' => 'Australian Dollar',
            ],
            [
                'currency' => 'BRL',
                'ratio' => 4.5397,
                'name' => 'Brazilian Real',
            ],
            [
                'currency' => 'CAD',
                'ratio' => 1.7552,
                'name' => 'Canadian Dollar',
            ],
            [
                'currency' => 'CNY',
                'ratio' => 8.9048,
                'name' => 'Chinese Yuan Renminbi',
            ],
            [
                'currency' => 'HKD',
                'ratio' => 10.977,
                'name' => 'Hong Kong Dollar',
            ],
            [
                'currency' => 'IDR',
                'ratio' => 18972.5685,
                'name' => 'Indonesian Rupiah',
            ],
            [
                'currency' => 'ILS',
                'ratio' => 4.9785,
                'name' => 'Israeli Shekel',
            ],
            [
                'currency' => 'INR',
                'ratio' => 90.1366,
                'name' => 'Indian Rupee',
            ],
            [
                'currency' => 'KRW',
                'ratio' => 1494.6117,
                'name' => 'South Korean Won',
            ],
            [
                'currency' => 'MXN',
                'ratio' => 25.9705,
                'name' => 'Mexican Peso',
            ],
            [
                'currency' => 'MYR',
                'ratio' => 5.4661,
                'name' => 'Malaysian Ringgit',
            ],
            [
                'currency' => 'NZD',
                'ratio' => 1.8978,
                'name' => 'New Zealand Dollar',
            ],
            [
                'currency' => 'PHP',
                'ratio' => 73.332,
                'name' => 'Philippine Piso',
            ],
            [
                'currency' => 'SGD',
                'ratio' => 1.8396,
                'name' => 'Singapore Dollar',
            ],
            [
                'currency' => 'THB',
                'ratio' => 43.9174,
                'name' => 'Thai Baht',
            ],
            [
                'currency' => 'ZAR',
                'ratio' => 16.3656,
                'name' => 'South African Rand',
            ]
        ];
    }
}
