<?php

namespace Mtc\Core\Http\Controllers\Admin;

use Mtc\Core\Http\Controllers\Controller;
use Illuminate\Support\Facades\Event;

/**
 * PopulateController
 *
 * Fire event to fetch all populate scripts.
 */
class PopulateController extends Controller
{
    /**
     * Displays all fetched populate scripts
     *
     * @return mixed
     */
    public function index()
    {
        $this->page_meta['title'] = 'Populate scripts';

        $twig_params = [
            'page_meta' => $this->page_meta,
            'populate_scripts' => Event::dispatch('admin.populate'),
        ];

        return template('admin/populate/index.twig', $twig_params);
    }

}
