<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class AddCoreTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('admin_menu', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('sub_id')->unsigned()->index()->default(0)->nullable();
            $table->string('title');
            $table->string('path')->nullable();
            $table->string('activePath')->nullable();
            $table->string('constant')->nullable();
            $table->string('icon')->nullable();
            $table->boolean('new_window')->default(0);
            $table->integer('order')->default(0);
            $table->string('permission_name')->nullable();
            $table->timestamps();
        });

        Schema::create('admin_users', function (Blueprint $table) {
            $table->increments('id');
            $table->string('password')->index();
            $table->string('email')->index();
            $table->string('session_id')->nullable();
            $table->string('name');
            $table->dateTime('last_login')->nullable()->index();
            $table->dateTime('last_updated')->nullable();
            $table->timestamps();
        });

        Schema::create('audit_log', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('subject_id')->unsigned()->index();
            $table->string('subject_type', 50)->default('')->index();
            $table->string('name');
            $table->binary('data')->nullable();
            $table->dateTime('date');
            $table->timestamps();
        });

        Schema::create('countries', function (Blueprint $table) {
            $table->increments('id');
            $table->boolean('status')->default(1)->index();
            $table->integer('order')->default(0)->index();
            $table->string('code', 2)->default('')->index();
            $table->string('name', 45)->default('')->index();
            $table->string('currency_code', 3)->nullable()->index();
            $table->double('north')->nullable();
            $table->double('south')->nullable();
            $table->double('east')->nullable();
            $table->double('west')->nullable();
            $table->string('capital_name', 30)->nullable();
            $table->string('continent_name', 15)->nullable();
            $table->string('continent_code', 2)->nullable();
            $table->string('languages', 100)->nullable();
            $table->string('iso_code', 3)->nullable()->index();
            $table->string('dial_code', 10)->nullable();
            $table->boolean('is_eu')->default(0)->index();
            $table->boolean('has_postcodes')->default(1)->index();
            $table->string('regex')->nullable();
            $table->timestamps();
        });

        Schema::create('country_states', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('country_id')->unsigned()->index();
            $table->string('name');
            $table->string('code')->index();
            $table->boolean('status')->index();
            $table->timestamps();
        });

        Schema::create('currencies', function (Blueprint $table) {
            $table->increments('id');
            $table->string('currency', 3);
            $table->double('ratio')->default(0);
            $table->string('symbol', 10)->default('');
            $table->string('name');
            $table->boolean('enabled')->default(0);
            $table->timestamps();
        });

        Schema::create('keywords', function (Blueprint $table) {
            $table->increments('id');
            $table->string('keyword')->unique();
            $table->timestamps();
        });

        Schema::create('settings', function (Blueprint $table) {
            $table->increments('id');
            $table->string('key', 100)->default('')->index();
            $table->string('environment', 50)->default('');
            $table->enum('type', ['', 'bool', 'int', 'float', 'string', 'array', 'object', 'null']);
            $table->text('value');
            $table->string('module', 50)->index()->nullable();
            $table->text('description')->nullable();
            $table->timestamps();

            $table->unique(['key', 'environment']);
        });

        Schema::create('seo_canonicals', function (Blueprint $table) {
            $table->increments('id');
            $table->string('path', 1023);
            $table->string('canonical_path', 1023);
            $table->timestamps();
            $table->index([DB::raw('path(191)')]);
        });

        Schema::create('seo_defaults', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name')->index();
            $table->string('path', 1023);
            $table->text('title')->nullable();
            $table->text('description')->nullable();
            $table->timestamps();
        });

        Schema::create('seo_pages', function (Blueprint $table) {
            $table->increments('id');
            $table->string('path', 1023);
            $table->text('title');
            $table->text('description');
            $table->timestamps();
            $table->index([DB::raw('path(191)')]);
        });

        Schema::create('seo_headings', function (Blueprint $table) {
            $table->increments('id');
            $table->string('path', 1023);
            $table->text('text')->nullable();
            $table->timestamps();
            $table->index([DB::raw('path(191)')]);
        });

        Schema::create('seo_redirects', function (Blueprint $table) {
            $table->increments('id');
            $table->string('old_url')->index();
            $table->string('new_url');
            $table->integer('hits')->index()->default(0);
            $table->string('code')->index();
            $table->timestamps();
        });

        Schema::create('seo_settings', function (Blueprint $table) {
            $table->string('key', 50)->primary();
            $table->string('value');
            $table->string('description');
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('admin_menu');
        Schema::dropIfExists('admin_users');
        Schema::dropIfExists('audit_log');
        Schema::dropIfExists('countries');
        Schema::dropIfExists('country_states');
        Schema::dropIfExists('currencies');
        Schema::dropIfExists('keywords');
        Schema::dropIfExists('settings');
        Schema::dropIfExists('seo_canonicals');
        Schema::dropIfExists('seo_defaults');
        Schema::dropIfExists('seo_pages');
        Schema::dropIfExists('seo_headings');
        Schema::dropIfExists('seo_redirects');
        Schema::dropIfExists('seo_settings');
    }
}
