<?php
/**
 * Class OutputImage
 *
 * @author Edvards Krickis <edvards.krickis@mtcmedia.co.uk>
 * @version 2018-08-06
 */
namespace Mtc\Core;

/**
 * Class OutputImage
 *
 * Output Image generator function.
 * Allows generating image or picture fields
 *
 * @author Edvards Krickis <edvards.krickis@mtcmedia.co.uk>
 * @version 2018-08-06
 */
class OutputImage
{
    /**
     * @var string[] currently supported fields and which templates they use
     */
    private static $supported_fields = [
        'image' => 'image',
        'picture' => 'picture'
    ];

    /**
     * Render a form field based on given $options.
     * This ensures all form fields are inline with general mtc styling.
     * Expected fields in options:
     * - type
     * - image_root
     * - pd
     * - src
     * - alt
     * - size
     * - loadify
     * - padding_top
     * - class
     * - responsive (array)
     * - responsive['breakpoint']
     *
     * @param string[] $options list of rendering params
     * @param \Twig_Environment $twig
     * @return string|void html of img or picture field|nothing if template not supported
     */
    public static function renderImageField(Array $options, \Twig_Environment $twig)
    {
        if (!empty($options['pd'])) {
            $options['alt'] = $options['pd']['alt'];
            $options['src'] = $options['pd']['value'];
        }

        if (empty($options['responsive'])) {
            $options['type'] = 'image';
        } else {
            $options['type'] = 'picture';

            foreach ($options['responsive'] as $key => $responsive_src) {

                if (!empty($responsive_src['pd'])) {
                    $options['responsive'][$key]['alt'] = $responsive_src['pd']['alt'];
                    $options['responsive'][$key]['src'] = $responsive_src['pd']['value'];
                }

                if (empty($responsive_src['src'])) {
                    $options['responsive'][$key]['src'] = $options['src'];
                }
            }
        }

        if (empty($options['image_root'])) {
            $options['image_root'] = 'cms_images';
        }

        if (!array_key_exists($options['type'], self::$supported_fields)) {
            return false;
        }

        $template = self::$supported_fields[$options['type']];
        return $twig->render("includes/output_images/{$template}.twig", $options);
    }
}