<?php

namespace Mtc\Core\Console\Commands;

use Illuminate\Console\Command;
use Mtc\Core\Images\ImageOptimise;

/**
 * Class ImageBulkOptimise
 *
 * @package App\Console\Commands
 */
class ImageBulkOptimise extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'images:bulk-optimise {--folder=uploads/images} {--quality=100} {--date=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Bulk process images in set folder by removing EXIF data and optionally compressing them';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {

        $folders = $this->option('folder') ?: 'uploads/images';
        $date = $this->option('date');
        $quality = $this->option('quality') ?: 100;

        ImageOptimise::bulkOptimiseImages([ $folders ], $date, $quality, false);
    }
}
