<?php

namespace Mtc\Core\Http\Controllers\Admin;

class ConfigController
{
    public function index()
    {
        return view('admin::config', [
            'templates' => $this->loadPackageConfigs(),
        ]);
    }

    private function loadPackageConfigs()
    {
        return collect(glob(base_path('vendor/mtcmedia/**/config/*.php')))
            ->flip()
            ->map(function ($order, $file_name) {
                return str_replace('<?php', '', file_get_contents($file_name));
            })
            ->keyBy(function ($content, $file_name) {
                return str_replace(base_path(), '', $file_name);
            });
    }
}
