<?php

namespace Mtc\Core\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\Core\Seo\Setting;

/**
 * Manages the installation of modules and plugins within the Core admin.
 */
class SeoController extends Controller
{
    /**
     * Displays Seo Settings
     *
     * @return mixed
     */
    public function index()
    {
        $this->page_meta['title'] = 'Manage SEO';
        $seo_settings = Setting::query()
            ->get()
            ->keyBy('key');

        return template('admin/seo/index.twig', [
            'page_meta' => $this->page_meta,
            'seo_settings' => $seo_settings,
        ]);
    }


    /**
     * Updates the Settings
     *
     * @param Request $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function post(Request $request)
    {
        $this->validate($request, [
            'settings' => 'required|array'
        ]);

        if (is_array($request->input('settings'))) {
            foreach ($request->input('settings') as $key => $value) {
                Setting::query()
                    ->where('key', $key)
                    ->update([
                        'value' => $value
                    ]);
            }
        }

        session()->flash('success', 'Your SEO settings have been updated!');
        return redirect()->back();
    }

    /**
     * Displays the Help page
     *
     * @return mixed
     */
    public function help()
    {
        $this->page_meta['title'] = 'Help';
        return template('admin/seo/help.twig', [
            'page_meta' => $this->page_meta,
        ]);
    }
}
