<?php

namespace Mtc\Core\Providers;

use Illuminate\Support\Facades\App;
use Illuminate\Support\ServiceProvider;
use Mtc\Core\Models\Country;
use Mtc\Core\Currency;

/**
 * Class CurrencyProvider
 *
 * Port for ensuring twig exists in Laravel system
 * In long term this should be replaced by a full templating engine
 * that allows adding new templates to loader
 *
 * @package Mtc\Core\Providers
 */
class CurrencyProvider extends ServiceProvider
{
    /**
     * Register the service
     */
    public function boot()
    {
        if ($this->app->runningInConsole()) {
            return;
        }

        $twig = App::make('twig');
        if (config('settings.ENABLE_CURRENCIES')) {
            $country = new Country();
            $country_location = $country->detectLocation($_REQUEST, $_COOKIE);
            $twig->addGlobal('location', $country_location);

            Currency::changeCurrency($_REQUEST);
        } elseif (($_SESSION['selected_currency'] ?? null) != Currency::SITE_CURRENCY) {
            // Explicitly set the site currency to value defined in class
            $_SESSION['selected_currency'] = Currency::SITE_CURRENCY;
            setcookie(
                "selected_currency",
                Currency::SITE_CURRENCY,
                time() + (2600 * 24 * 30 * 6),
                "/"
            );
        }

        $twig->addGlobal('currency', Currency::getCurrency());
        $twig->addGlobal('selected_currency', $_SESSION['selected_currency']);
    }
}
