<?php

namespace Mtc\Core\Providers;

use Illuminate\Support\Facades\Cache;
use Mtc\Core\Console\Commands\CurrencyUpdate;
use Mtc\Core\Console\Commands\DumpAutoload;
use Mtc\Core\Console\Commands\ImageBulkOptimise;
use Mtc\Core\Console\Commands\ImageOptimiseCommand;
use Mtc\Core\Console\Commands\ReuploadCommand;
use Mtc\Core\Console\Commands\TemplateClearCommand;
use Illuminate\Support\Facades\App;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Mtc\Core\Admin\Setting;
use Mtc\Core\Media\MediaLoader;

/**
 * Class CoreServiceProvider
 *
 * @package Mtc\Core\Providers
 */
class CoreServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        $this->loadViewsFrom(dirname(__DIR__, 2) . '/resources/views', 'admin');
        Schema::defaultStringLength(191);
        Setting::defineUserSettings();
        $this->defineConstants();
        $this->commands([
            TemplateClearCommand::class,
            DumpAutoload::class,
            CurrencyUpdate::class,
            ImageBulkOptimise::class,
            ReuploadCommand::class,
            ImageOptimiseCommand::class,
        ]);
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/admin.php', 'admin');
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations/');
        $this->registerMedia();

        $this->app->register(CoreModuleServiceProvider::class);
        $this->app->register(RouteServiceProvider::class);
        $this->app->register(TwigServiceProvider::class);
        $this->app->register(CurrencyProvider::class);
    }

    /**
     * Define site wide used constants
     */
    public function defineConstants()
    {
        if (!defined('SITE')) {
            define('SITE', config('app.site_id'));
            define('THEME_PATH', '/sites/' . SITE);
            define('THEME_URL', THEME_PATH);
        }

        if ($this->app->runningInConsole() === false) {
            $this->defineSeoSettings();
        }
    }

    /**
     * Register Media related functionality
     */
    protected function registerMedia()
    {
        App::singleton('image_folders', function () {
            return [];
        });
        App::bind('media_loader', function () {
            return new MediaLoader();
        });
    }

    /**
     * Define seo settings
     */
    private function defineSeoSettings()
    {
        $seo_settings = Cache::rememberForever('seo-settings', function () {
            return \Mtc\Core\Seo\Setting::query()->pluck('value', 'key');
        });

        $seo_settings
            ->reject(function ($setting, $key) {
                return defined($key);
            })
            ->each(function ($setting, $key) {
                define($key, $setting);
            });
    }
}
