<?php

namespace Mtc\Core\Rules;

use Illuminate\Contracts\Validation\Rule;

/**
 * Class SecurePassword
 *
 * @package Mtc\Core
 */
class SecurePassword implements Rule
{
    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        preg_match("/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d).+$/", $value, $matches);
        return !empty($matches);
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'Password is too weak. Must include both lowercase and uppercase letters and numbers';
    }
}
