<?php

namespace Mtc\Core\Seo;

/**
 * Seo csv class
 *
 * @author Lukas Giegerich | mtc.
 * @version 2014-01-20
 */
class SeoCSV
{
    /**
     * echoes a csv of the given type (paths, brands or cats) to use for dl
     *
     * @param string $type
     */
    public static function csvPrint($type)
    {
        $db = new \MtcPdo();
        if ($type === 'paths') {
            $db->run("SELECT * FROM `seo_pages` ORDER BY `path`");
        } elseif ($type === 'brands') {
            $db->run("SELECT `id`, `name`, `seo_title`, `seo_description` FROM `brands` ORDER BY `id`");
        } elseif ($type === 'categories') {
            $db->run("SELECT `id`, `name`, `seo_title`, `seo_description` FROM `categories` ORDER BY `id`");
        } elseif ($type === 'headings') {
            $db->run("SELECT `id`, `path`, `text` FROM `seo_headings` ORDER BY `id`");
        } elseif ($type === 'redirects') {
            $db->run("SELECT `code`, `old_url`, `new_url` FROM `seo_redirects` ORDER BY `id`");
        }

        if (empty($query)) {
            return null;
        }

        $i = 0;
        while ($data = $db->fetch_array()) {
            if ($i == 0) {
                $headers = array_keys($data);
                foreach ($headers as $key => $value) {
                    if (is_numeric($value)) {
                        unset($headers[$key]);
                    }
                }
                echo self::outPutCsv($headers);
            }
            foreach ($data as $key => $value) {
                if (is_numeric($key)) {
                    unset($data[$key]);
                }
            }
            echo self::outPutCsv($data);
            $i++;
        }
    }

    /**
     * The joy of fputcsv() returning a string
     *
     * @param array $array
     * @return string
     */
    private static function outPutCsv($array)
    {
        ob_start();
        $fp = fopen('php://output', 'w');
        fputcsv($fp, $array);
        fclose($fp);
        return ob_get_clean();
    }

    /**
     * Method to process csv file upload into respective SEO type
     *
     * @param string $type
     */
    public static function importCsv($type)
    {
        $db = new \MtcPdo();

        $lookup = [];

        if ($type == 'paths') {
            $lookup = [
                'id' => 'id',
                'title' => 'title',
                'description' => 'description',
            ];
        } elseif ($type == 'brands' || $type == 'categories') {
            $lookup = [
                'id' => 'id',
                'seo_title' => 'title',
                'seo_description' => 'description',
            ];
        } elseif ($type == "redirects") {
            $lookup = [
                'old_url' => 'old_url',
                'new_url' => 'new_url',
                'code' => 'code'
            ];
        }

        if (isset($_FILES['csv']) && $_FILES['csv']['size'] > 0) {
            if (($handle = fopen($_FILES['csv']['tmp_name'], 'r')) !== false) {
                $first = true;
                $header_index = [];

                while (($data = fgetcsv($handle, 0, ',')) !== false) {
                    if ($first) {
                        $header_index = $data;
                        $first = false;
                        continue;
                    }

                    $params = [];
                    foreach ($data as $key => $value) {
                        if (isset($lookup[$header_index[$key]])) {
                            $params[':' . $lookup[$header_index[$key]]] = $value;
                        }
                    }

                    if ($type == 'paths') {
                        $params = array(
                            ':id' => $data[array_search('id', $header_index)],
                            ':path' => $data[array_search('path', $header_index)]
                        );

                        $query = "SELECT `id` "
                            . " FROM `seo_pages` "
                            . " WHERE `id` = :id"
                            . " OR `path` = :path";

                        $db->run($query, $params);

                        if ($db->num_rows() > 0) {
                            $data2 = $db->fetch_array();

                            $params[':id'] = $data2['id'];
                            $params[':title'] = $data[array_search('title', $header_index)];
                            $params[':description'] = $data[array_search('description', $header_index)];
                            unset($params[':path']);

                            $query = "UPDATE `seo_pages`
                                        SET " . " `title` = :title,"
                                . " `description` = :description"
                                . " WHERE `id` = :id";

                            $db->run($query, $params);
                        } else {
                            unset($params[':id']);
                            $params[':path'] = $data[array_search('path', $header_index)];
                            $params[':title'] = $data[array_search('title', $header_index)];
                            $params[':description'] = $data[array_search('description', $header_index)];

                            $query = "INSERT INTO `seo_pages`"
                                . " (`id`, `title`, `description`, `path`)"
                                . " VALUES('', :title, :description, :path)";

                            $db->run($query, $params);
                        }
                    } elseif ($type == 'brands') {
                        $query = "UPDATE `brands`
                                    SET " . " `seo_title` = :title,"
                            . " `seo_description` = :description"
                            . " WHERE `id` = :id";

                        $db->run($query, $params);
                    } elseif ($type == 'categories') {
                        $query = "UPDATE `categories`
                                    SET " . " `seo_title` = :title,"
                            . " `seo_description` = :description"
                            . " WHERE `id` = :id";

                        $db->run($query, $params);
                    } elseif ($type == 'redirects') {
                        $check_redirect = Redirect::where('old_url', '=', $data[array_search('old_url', $header_index)])
                            ->where('new_url', '=', $data[array_search('new_url', $header_index)])
                            ->count();

                        if ($check_redirect == 0) {
                            $params = [
                                'code' => $data[array_search('code', $header_index)],
                                'new_url' => $data[array_search('new_url', $header_index)],
                                'old_url' => $data[array_search('old_url', $header_index)]
                            ];

                            $redirect = new Redirect();
                            $redirect->fill($params);
                            $redirect->save();
                        }
                    }
                }
                fclose($handle);
            }
        }
    }
}
