<?php

namespace Mtc\Core\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\Core\Seo\Csv;

/**
 * Class SeoCsvController
 *
 * @package Mtc\Core\Http\Controllers\Admin
 */
class SeoCsvController extends Controller
{
    /**
     * Import CSV File
     *
     * @return \Illuminate\Http\RedirectResponse
     */
    public function import(Request $request)
    {
        try {
            Csv::importCsv($request, $request->input('type'));
            session()->flash('success', 'Your CSV file has now been imported!');
        } catch (\Exception $exception) {
            session()->flash('error', $exception->getMessage());
        }
        return redirect()->back();
    }

    /**
     * Export CSV File
     *
     * @param Request $request
     */
    public function export(Request $request)
    {
        $this->validate($request, [
            'type.*' => 'in:paths,categories,brands,headings,redirects'
        ]);

        $type = $request->input('type');
        header('Content-Type: application/csv');
        header('Content-Disposition: attachment; filename=' . clean_value(config('app.name') . '_' . $type) . '.csv');
        header('Pragma: no-cache');
        echo Csv::csvPrint($type);
    }
}
