@extends('foundation::layouts.admin')

@section('title', 'Dashboard')

@section('content')

    <ul class="breadcrumbs el">
        <li><a href="/admin/">Home</a> /</li>
        <li class="end">Dashboard</li>
    </ul>

    <h1>
        Secure Website Admin Area
    </h1>

    <p>
        Welcome to {{ config('app.name') }} secure admin area.
        Please select from one of the options on the left hand side to
        begin administering the site.
    </p>

    <p>
        Please do not hesitate to contact
        <a href="http://www.mtcmedia.co.uk/" target="_blank">mtc.</a>
        at any time for technical support.
    </p>

    @foreach($dashboard_events as $event)
        {!! $event !!}
    @endforeach

    @if (config('settings.ADVANCED_STATS_ENABLED') || config('settings.GRAPH_STATS_ENABLED'))
        <div id="dashboardStats">

            @if ( config('settings.GRAPH_STATS_ENABLED') && !empty($graphs))
                <div class="el cols{{ $graph_columns }}">
                    @foreach($graphs as $graph)
                        <div class="col el {{ $loop->index % $graph_columns == 0 ? 'first' : '' }}">
                            <h3>{{ $graph['name'] }}</h3>
                            <div class="el graph js_dashboardStat"
                                    id="{{ $graph['id'] }}"
                                    data-url="{{ $graph['url'] }}">
                                <i class="fa fa-circle-o-notch fa-spin fa-3x dashboardIcon"></i>
                            </div>
                        </div>
                    @endforeach
                </div>
            @endif

            <form action="" method="post" id="dashboard-dates">
                <div class="row">
                    <input type="text"
                            class="datepicker short"
                            name="start_date"
                            id="start-date"
                            placeholder="DD/MM/YYYY"
                            value="{{ $start_date }}" />
                    <span class="between-dates"> to </span>
                    <input type="input"
                            class="datepicker short"
                            name="end_date"
                            id="end-date"
                            placeholder="DD/MM/YYYY"
                            value="{{ $end_date }}" />
                    <input type="submit" name="go-dashboard" id="filter-dates" value="Filter" />
                </div>
            </form>

            @if ( config('settings.GRAPH_STATS_ENABLED') && !empty($numeric_stats))
                <div class="el cols{{ $table_columns }}">
                    @foreach ($numeric_stats as $stats)
                        <div class="col el numeric_stats js_dashboardStatListing {{ $loop->index % $table_columns == 0 ? 'first' : '' }}"
                                id="{{ $stats['id'] }}"
                                data-url="{{ $stats['url'] }}">
                            <i class="fa fa-circle-o-notch fa-spin fa-3x dashboardIcon"></i>
                        </div>
                    @endforeach
                </div>
            @endif
        </div>
    @endif
@endsection

@section('after_assets')
    @if ( config('settings.GRAPH_STATS_ENABLED') && !empty($graphs))
        <script type="text/javascript" src='https://www.gstatic.com/charts/loader.js?autoload={"modules":[{"name":"visualization","version":"1.1","packages":["corechart"]}]}'></script>
    @endif
@endsection
