<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class AddOnlyMembersAndAllStockForCouponsTable
 */
class AddOnlyMembersAndAllStockForCouponsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('coupons', function (Blueprint $table) {
            $table->addColumn('boolean', 'all_stock')->default(0);
            $table->addColumn('boolean', 'members_only')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('coupons', function (Blueprint $table) {
            $table->dropColumn('all_stock');
            $table->dropColumn('members_only');
        });
    }
}
