<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class AddBasicRestrictionsToCouponsTable
 */
class AddBasicRestrictionsToCouponsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('coupons', function (Blueprint $table) {
            $table->dropColumn('min_basket_price');
            $table->dropColumn('only_first_purchase');
            $table->dropColumn('all_stock');
            $table->dropColumn('members_only');
            $table->text('basic_restrictions');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('coupons', function (Blueprint $table) {
            $table->decimal('min_basket_price', 10)->nullable()->index();
            $table->boolean('only_first_purchase')->default(0);
            $table->boolean('all_stock')->default(0);
            $table->boolean('members_only')->nullable();
            $table->dropColumn('basic_restrictions');
        });
    }
}
