<?php

namespace Mtc\Coupons\Filters;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Mtc\Foundation\Contracts\AdminFilter;

/**
 * Class FilterByDateFrom
 * 
 * @package Mtc\Orders\Filters
 */
class FilterByDateFrom implements AdminFilter
{
    /**
     * Constant for input field name
     */
    const INPUT_FIELD_NAME = 'date_from';

    /**
     * Field definition
     *
     * @return mixed
     */
    public function field()
    {
        return [
            'type' => 'text',
            'name' => self::INPUT_FIELD_NAME,
            'label' => 'Date From',
            'class' => 'datepicker',
            'value' => \request(self::INPUT_FIELD_NAME),
        ];
    }

    /**
     * Handle the filtering of a field
     *
     * @param Request $request
     * @param Builder $query
     * @return Builder
     */
    public function handle(Request $request, Builder $query): Builder
    {
        if (empty($request->input(self::INPUT_FIELD_NAME))) {
            return $query;
        }

        try {
            $date = Carbon::createFromFormat('d/m/Y', $request->input(self::INPUT_FIELD_NAME));

            return $query->where('date_to', '>=', $date);
        } catch (\Exception $exception) {
            return $query;
        }
    }
}
