<?php

namespace Mtc\Coupons\Validators;

use Mtc\Basket\Contracts\BasketContract;
use Mtc\Coupons\Coupon;

/**
 * Class BasketPrice
 * @package Mtc\Coupons\Validators
 */
class BasketPrice
{
    /**
     * @param Coupon $coupon
     * @param $basket
     * @return bool
     */
    public function validate(Coupon $coupon, $basket) : bool
    {
        //Check if discount have min basket price
        //Check if basket cost subtotal > discount min basket price
        if (
            $coupon->getBasicRestriction('minimum_basket_price') > 0 &&
            $basket->cost_subtotal <= $coupon->getBasicRestriction('minimum_basket_price')
        ) {
            return false;
        }


        return true;
    }
}
