<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class ChangeValue2ForDiscountTable
 */
class ChangeShippingModifierColumnForCouponsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('coupons', function (Blueprint $table) {
            $table->string('shipping_modifier', 50)->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('coupons', function (Blueprint $table) {
            $table->dropColumn('shipping_modifier');
        });

        Schema::table('coupons', function (Blueprint $table) {
            $table->unsignedTinyInteger('shipping_modifier')->nullable()->index();
        });
    }
}
