<?php

namespace Mtc\Coupons\Listeners;

use Illuminate\Support\Facades\App;
use Mtc\Basket\Basket;
use Mtc\Basket\Http\Resources\BasketAjax;
use Mtc\Basket\Http\Resources\CheckoutAjax;

/**
 * Class SetBasketDiscount
 * @package Mtc\MultiBuy\Listeners
 */
class AddApplicableItems
{
    /**
     * @var BasketAjax|CheckoutAjax
     */
    protected $event = null;

    /**
     * @var Basket
     */
    protected $basket = null;

    /**
     * Handle the event.
     *
     * @param $event
     */
    public function handle($event)
    {
        $this->basket = $event->getModel();
        $this->basket->discounts()
            ->where('discount_type', 'coupon')
            ->get()
            ->each(function ($discount) {
                $coupon = $discount->discount;
                App::make(config('coupons.discount_types.' . $coupon->type . '.class'))
                    ->apply($coupon, $this->basket, false);
            });
    }
}
