<?php

namespace Mtc\Coupons\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider;
use Mtc\Basket\Events\LoadBasketExtensions;
use Mtc\Coupons\Listeners\AddApplicableItems;
use Mtc\Coupons\Listeners\AddCouponFormToBasket;
use Mtc\Coupons\Listeners\DecrementCouponRedemptionOnOrderPaid;
use Mtc\MultiBuy\Listeners\SetBasketDiscount;
use Mtc\Orders\Events\OrderPaid;

/**
 * Class BasketRouteServiceProvider
 *
 * @package Mtc\Basket\Providers
 */
class CouponEventServiceProvider extends EventServiceProvider
{
    /**
     * The event handler mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        LoadBasketExtensions::class => [
            AddCouponFormToBasket::class
        ],
        SetBasketDiscount::class => [
            AddApplicableItems::class
        ],
        OrderPaid::class => [
            DecrementCouponRedemptionOnOrderPaid::class,
        ]
    ];
}
