<?php

namespace Mtc\Coupons\Restrictions;

use Mtc\Basket\Contracts\BasketContract;
use Mtc\Coupons\Coupon;

/**
 * Class BrandRestriction
 * @package Mtc\Coupons\Restrictions
 */
class BrandRestriction
{
    /**
     * @param Coupon $coupon
     * @param $item
     * @param $restriction
     * @param $restrictions_count
     * @return bool
     */
    public function validate(Coupon $coupon, $item, $restriction, $restrictions_count): bool
    {
        // Coupon doesn't have any restriction
        if (!$restrictions_count['excluded'] && !$restrictions_count['included']) {
            return false;
        }

        $brands = $item->purchasable->brands ?: $item->purchasable->item->brands;
        $restriction_brands_exists = $brands
            ->contains('id', $restriction->discountable_id);

        // Coupon contains only excluded restrictions
        if ($restrictions_count['excluded'] && !$restrictions_count['included']) {
            return !(bool)$restriction_brands_exists;
        }

        // Coupon contains only included restrictions
        if ($restrictions_count['included'] && !$restrictions_count['excluded']) {
            return (bool)$restriction_brands_exists;
        }

        // Coupon contains both included and excluded restrictions
        return $restriction->exclude ? !(bool)$restriction_brands_exists : (bool)$restriction_brands_exists;
    }
}
