<?php

namespace Mtc\Coupons\Restrictions;

use Mtc\Basket\Contracts\BasketContract;
use Mtc\Coupons\Coupon;

/**
 * Class CategoryRestriction
 * @package Mtc\Coupons\Restrictions
 */
class CategoryRestriction
{
    /**
     * @param Coupon $coupon
     * @param $item
     * @param $restriction
     * @param $restrictions_count
     * @return bool
     */
    public function validate(Coupon $coupon, $item, $restriction, $restrictions_count): bool
    {
        // Coupon doesn't have any restriction
        if (!$restrictions_count['excluded'] && !$restrictions_count['included']) {
            return false;
        }

        $categories = $item->purchasable->categories ?: $item->purchasable->item->categories;
        $restriction_category_exists = $categories
            ->contains('id', $restriction->discountable_id);

        // Coupon contains only excluded restrictions
        if ($restrictions_count['excluded'] && !$restrictions_count['included']) {
            return !(bool)$restriction_category_exists;
        }

        // Coupon contains only included restrictions
        if ($restrictions_count['included'] && !$restrictions_count['excluded']) {
            return (bool)$restriction_category_exists;
        }

        // Coupon contains both included and excluded restrictions
        return $restriction->exclude ? !(bool)$restriction_category_exists : (bool)$restriction_category_exists;
    }
}
