<?php

namespace Mtc\Coupons\Rules;

use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Facades\App;
use Mtc\Basket\Basket;
use Mtc\Coupons\Facades\Coupon;
use Mtc\Foundation\PostcodeValidationFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ValidPostcode
 *
 * @package Mtc\Foundation\Rules
 */
class ApplicableCoupon implements Rule
{
    /**
     * @var Basket
     */
    protected $basket;

    /**
     * Create a new rule instance.
     *
     * @param Basket $basket
     * @return void
     */
    public function __construct(Basket $basket)
    {
        $this->basket = $basket;
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        return App::make('coupon-validator')->validate($value);
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return __('coupons::coupons.validation.not_applicable');
    }
}
