<?php

namespace Mtc\Coupons\Rules;

use Illuminate\Contracts\Validation\Rule;
use Mtc\Basket\Basket;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Coupons\Facades\Coupon;
use Mtc\Foundation\PostcodeValidationFactory;

/**
 * Class ValidPostcode
 *
 * @package Mtc\Foundation\Rules
 */
class CouponAlreadyApplied implements Rule
{
    /**
     * @var BasketRepositoryInterface
     */
    protected $basket;

    /**
     * Create a new rule instance.
     *
     * @param BasketRepositoryInterface $basket
     * @return void
     */
    public function __construct(BasketRepositoryInterface $basket)
    {
        $this->basket = $basket;
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        $code = Coupon::getFromCode($value);
        return $code ? !$this->basket->hasDiscount($code->id, config('coupons.coupon_class')) : false;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return __('coupons::coupons.validation.already_applied');
    }
}
