<?php

namespace Mtc\Coupons\Listeners;

use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Mtc\Orders\Events\OrderPaid;

/**
 * Class DecrementRedemptionOnOrderPaid
 *
 * @package Mtc\Coupons\Listeners
 */
class DecrementCouponRedemptionOnOrderPaid
{

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return array|null
     */
    public function handle(OrderPaid $event)
    {
        if (config('coupons.enabled', false) !== true) {
            return null;
        }

        $event->getOrder()->discounts
            ->filter(function ($order_discount) {
                return $order_discount->discount_type === 'coupon';
            })
            ->each(function ($order_discount) {
                $order_discount->discount->decrement('redemptions');
            });
    }
}
