<?php

namespace Mtc\Coupons\Console\Commands;

use Illuminate\Console\Command;
use Mtc\Coupons\Providers\CouponServiceProvider;
use Mtc\Coupons\Seeds\CouponsSeeder;
use Mtc\Coupons\Seeds\ShippingModifierSeeder;

/**
 * Class InstallCoupons
 * @package Mtc\Coupons\Console\Commands
 */
class InstallCoupons extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'install:coupons';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Install Coupons default assets/data';

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        $this->info('Installing Coupons');
        $this->callSilent('migrate');

        $this->callSilent('vendor:publish', [
            '--provider' => CouponServiceProvider::class,
            '--tag' => 'assets',
        ]);

        $this->comment('Setting up database');
        $this->call('db:seed', [
            '--class' => CouponsSeeder::class
        ]);

        $this->call('db:seed', [
            '--class' => ShippingModifierSeeder::class
        ]);


        $this->info('Coupons installed successfully.');
    }
}
