<?php

namespace Mtc\Coupons\Seeds;

use Illuminate\Database\Seeder;
use Mtc\ShippingManager\TableRate;

/**
 * Class ShippingModifierSeeder
 * @package Mtc\Coupons\Seeds
 */
class ShippingModifierSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->addShippingModifiers();
    }

    /**
     * Add Shipping Modifiers
     */
    protected function addShippingModifiers()
    {
        //Check if Shipping manager exists
        if (!config('shipping_manager.enabled')) {
            return;
        }

        $free_rates = TableRate::query()
            ->where('name', 'LIKE', '%Free%')
            ->with('zone')
            ->get();

        $uk_free_rates = $free_rates->filter(function($rate) {
            return $rate->zone->name == 'UK';
        });

        $this->addShippingModifierToRates($uk_free_rates, 'free-uk-delivery-coupon');
        $this->addShippingModifierToRates($free_rates, 'free-worldwide-delivery-coupon');
    }

    /**
     * Add Shipping Modifier To rates
     *
     * @param $rates
     * @param $shipping_modifier
     */
    protected function addShippingModifierToRates($rates, $shipping_modifier)
    {
        $rates->each(function($rate) use ($shipping_modifier) {
            $rate->modifiers = collect($rate->modifiers)
                ->push($shipping_modifier)
                ->unique();
            $rate->save();
        });
    }
}
