<?php

namespace Mtc\Coupons\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\App;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Coupons\Rules\ActiveCoupon;
use Mtc\Coupons\Rules\ApplicableCoupon;
use Mtc\Coupons\Rules\CouponAlreadyApplied;

class ApplicableCouponRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $basket = App::make('basket');
        return [
            'code' => [
                new ActiveCoupon($basket),
                new CouponAlreadyApplied(App::make(BasketRepositoryInterface::class)),
                new ApplicableCoupon($basket),
            ]
        ];
    }
}
