<?php

namespace Mtc\Coupons\Rules;

use Illuminate\Contracts\Validation\Rule;

/**
 * Class ValidCouponCodeValue
 *
 * @package Mtc\Foundation\Rules
 */
class ValidCouponCodeValue implements Rule
{
    /**
     * Excluded chars
     *
     * @var array
     */
    protected $excluded_chars = [
        '0',
        'O',
        'l',
        'I',
        '1',
    ];

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        return $value === str_replace($this->excluded_chars, [''], $value);
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return __('coupons::coupons.validation.unsupported_characters', [
            'restricted_chars' => collect($this->excluded_chars)->implode(',')
        ]);
    }
}
