<?php

namespace Mtc\Coupons\Rules;

use Illuminate\Contracts\Validation\Rule;

/**
 * Class ValidCouponDiscountValue
 *
 * @package Mtc\Foundation\Rules
 */
class ValidCouponDiscountValue implements Rule
{
    /**
     * @var string
     */
    protected $type;

    /**
     * Create a new rule instance.
     *
     * @param string $type
     * @return void
     */
    public function __construct($type)
    {
        $this->type = $type;
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        return $this->type === 'percentage' ? $value <= 100 : true;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return __('coupons::coupons.validation.percentage_not_higher_than_100');
    }
}
