<?php

namespace Mtc\Coupons\Types;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\App;
use Mtc\Basket\Basket;
use Mtc\Coupons\Contracts\CouponRepositoryInterface;
use Mtc\Coupons\Contracts\TypeContract;
use Mtc\Coupons\Repositories\CouponRepository;

/**
 * Class CouponTypeBase
 * @package Mtc\Coupons
 */
abstract class CouponTypeBase implements TypeContract
{
    /**
     * @var Basket
     */
    protected $basket = null;

    /**
     * @var CouponRepository
     */
    protected $coupon;

    /**
     * @var Collection|null
     */
    protected $applicable_items;

    /**
     * Apply Coupon Amount
     *
     * @param Model $coupon
     * @param $basket
     * @param bool $set_discounted_amount
     */
    public function apply(Model $coupon, $basket, bool $set_discounted_amount = true)
    {
        $this->basket = $basket;
        $this->coupon = App::make(CouponRepositoryInterface::class);
        $this->coupon->setModel($coupon);
        $this->coupon->setBasketModel($this->basket);

        if (!$this->coupon->isAvailable($this->basket)) {
            $coupon->discounted_amount = 0;
            $this->coupon->addApplicableItemsToBasket();
            return;
        }

        $this->applicable_items = $this->coupon->getBasketApplicableItems();
        if ($set_discounted_amount) {
            $coupon->discounted_amount = $this->getDiscountedAmount();
        }
        $this->coupon->addApplicableItemsToBasket();
    }

    /**
     * Get Discounted values for item line
     *
     * @param $coupon
     * @param $item
     * @return float
     */
    abstract public function getDiscountedValues($coupon, $item);
}
