<?php

use Faker\Generator as Faker;

$factory->define(\Mtc\Coupons\Coupon::class, function (Faker $faker) {

    $date_from = random_int(0, 4) ? \Carbon\Carbon::now()->subDays(random_int(0, 100)) : \Carbon\Carbon::now()->addDays(random_int(0, 100));
    $date_to = $date_from->copy()->addDays(random_int(0, 200));
    $template_id = random_int(0, 1) ? \Mtc\Coupons\Coupon::query()->inRandomOrder()->first()->id ?? 0 : 0;

    return [
        'template_id' => $template_id,
        'is_template' => $template_id ? 0 : random_int(0, 1),
        'code' => str_random(16),
        'name' => $faker->name,
        'valid_from' => $date_from,
        'valid_to' => $date_to,
        'redemptions' => random_int(0, 10),
        'type' => random_int(0, 1) ? 'percentage': 'amount',
        'value' => random_int(0, 500),
        'sale_restriction' => random_int(0, 1),
    ];
});

$factory->define(\Mtc\Coupons\Restriction::class, function (Faker $faker) {

    $discountable = collect([
        \Mtc\Shop\Item::class,
        \Mtc\Shop\Category::class,
    ])->random();

    if (random_int(0, 2)) {
        $discountable_id = \Illuminate\Support\Facades\App::make($discountable)->newQuery()->inRandomOrder()->first()->id ?? 0;
    }  else {
        $discountable_id = 0;
    }

    return [
        'discountable_id' => $discountable_id,
        'discountable_type' => $discountable,
        'exclude' => random_int(0, 1)
    ];
});
