<?php

namespace Mtc\Coupons\Types;

/**
 * Class PercentOffAll
 * @package Mtc\Coupons\Types
 */
class PercentOffAll extends CouponTypeBase
{
    /**
     * Get Total Discounted Amount
     *
     * @return float
     */
    protected function getDiscountedAmount()
    {
        return round($this->basket->getCostSubtotalAttribute() / 100 * $this->coupon->getModel()->value, 2);
    }

    /**
     * Get Discounted Values
     *
     * @param $coupon
     * @param $item
     * @return float
     */
    public function getDiscountedValues($coupon, $item)
    {
        return [
            'discounted_percent' => $coupon->value,
        ];
    }
}
