<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Coupons package
    |--------------------------------------------------------------------------
    |
    | Enabled/disabled package
    */

    'enabled' => true,

    /*
    |--------------------------------------------------------------------------
    | Provider classes
    |--------------------------------------------------------------------------
    |
    | Additional service providers.
    |
    */

    'service_providers' => [
        \Mtc\Coupons\Providers\CouponRouteServiceProvider::class,
        \Mtc\Coupons\Providers\CouponEventServiceProvider::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Class bindings
    |--------------------------------------------------------------------------
    |
    | These settings define classes that will be used by the application
    |
    */
    
    'coupon_class' => \Mtc\Coupons\Coupon::class,
    'repository_class' => \Mtc\Coupons\Repositories\CouponRepository::class,
    'validator_class' => \Mtc\Coupons\Validator::class,
    'restriction_class' => \Mtc\Coupons\Restriction::class,

    /*
    |--------------------------------------------------------------------------
    | Admin search filters
    |--------------------------------------------------------------------------
    |
    | Classes that will implement search filters on admin list page
    | Each class is expected to follow the format of AdminFilter interface
    |
    */

    'admin_search_filters' => [
        \Mtc\Foundation\Filters\FilterById::class,
        \Mtc\Foundation\Filters\FilterByCode::class,
        \Mtc\Coupons\Filters\FilterByStatus::class,
        \Mtc\Coupons\Filters\FilterByDateFrom::class,
        \Mtc\Coupons\Filters\FilterByDateTo::class,
    ],

    'admin' => [
        'pagination' => 20,
    ],

    /*
    |--------------------------------------------------------------------------
    | Supported Coupon types
    |--------------------------------------------------------------------------
    |
    | We set the supported discount types here
    | Discount Types allow applying different techniques for discounts
    | Base examples are percentage and set amount discounts
    |
    */

    'discount_types' => [
        'percentoff' => [
            'description' => '{VALUE} percent off discount per item',
            'class' => \Mtc\Coupons\Types\PercentOff::class
        ],
        'percentoffall' => [
            'description' => '{VALUE} percent off to basket',
            'class' => \Mtc\Coupons\Types\PercentOffAll::class
        ],
        'amountoff' => [
            'description' => '{VALUE} amount discount per item',
            'class' => \Mtc\Coupons\Types\AmountOff::class
        ],
        'amountoffall' => [
            'description' => '{VALUE} amount discount to basket',
            'class' => \Mtc\Coupons\Types\AmountOffAll::class
        ]
    ],

    /*
    |--------------------------------------------------------------------------
    | Stacking restrictions
    |--------------------------------------------------------------------------
    |
    | These settings determine whether discounts can be stacked on top of each
    | other.
    |
    */

    'allow_coupon_stacking' => false,
    'allow_discount_stacking' => true,

    /*
    |--------------------------------------------------------------------------
    | Restrictions information
    |--------------------------------------------------------------------------
    |
    | Show information text before restrictions
    */

    'restrictions_information_text' => true,

    /*
    |--------------------------------------------------------------------------
    | Restrictions
    |--------------------------------------------------------------------------
    |
    | Define the base restrictions
    | Restriction contains Morph alias, Description and Validation class
    | These restrictions will be used to verify coupon applies to basket
    */

    'restrictions' => [
        'items' => [
            'item' => [
                'priority' => 10,
                'description' => 'Item restrictions',
                'validation' => \Mtc\Coupons\Restrictions\ItemRestriction::class
            ],
            'category' => [
                'priority' => 9,
                'description' => 'Category restrictions',
                'validation' => \Mtc\Coupons\Restrictions\CategoryRestriction::class
            ],
            'brand' => [
                'priority' => 8,
                'description' => 'Brand restrictions',
                'validation' => \Mtc\Coupons\Restrictions\BrandRestriction::class
            ]
        ],
        'basket' => []
    ],

    /*
    |--------------------------------------------------------------------------
    | Basic restrictions
    |--------------------------------------------------------------------------
    |
    | Basket validation
    |
    */

    'basic_restrictions' => [
        'minimum_basket_price' => [
            'enabled' => true,
            'type' => 'text',
            'request_rule' => 'nullable|numeric|min:0',
            'description' => 'Minimum Basket Value (£)',
            'validator' => \Mtc\Coupons\Validators\BasketPrice::class,
        ],
        'members_only' => [
            'enabled' => true,
            'type' => 'checkbox',
            'request_rule' => 'nullable|integer',
            'description' => 'Members only',
            'validator' => \Mtc\Coupons\Validators\MembersOnly::class,
        ],
        'only_first_purchase' => [
            'enabled' => true,
            'type' => 'checkbox',
            'request_rule' => 'nullable|integer',
            'description' => 'Only first purchase',
            'validator' => \Mtc\Coupons\Validators\FirstPurchase::class,
        ]
    ],

    /*
    |--------------------------------------------------------------------------
    | Validation per item
    |--------------------------------------------------------------------------
    |
    | Validations goes after basic restrictions (basket validation)
    | Mark basket item as applicable
    |
    */

    'item_checks' => [
        \Mtc\Coupons\Validators\DiscountableItem::class
    ],

    /*
    |--------------------------------------------------------------------------
    | Sale Restrictions
    |--------------------------------------------------------------------------
    |
    | Define the sale restrictions
    | These restrictions will be used to verify coupon applies to basket
    */

    'sale_restrictions' => [
        \Mtc\Coupons\Coupon::ALL_ITEMS => 'Applies to both sale and non-sale items',
        \Mtc\Coupons\Coupon::NON_SALE_ITEMS => 'Applies to only non-sale items',
        \Mtc\Coupons\Coupon::ONLY_SALE_ITEMS => 'Applies to only sale items',
    ],

    /*
    |--------------------------------------------------------------------------
    | Shipping modifiers
    |--------------------------------------------------------------------------
    |
    | Classes that allow customizing shipping
    |
    */

    'shipping_modifiers' => [
        'free-uk-delivery-coupon' => \Mtc\Coupons\Modifiers\FreeUkDelivery::class,
        'free-worldwide-delivery-coupon' => \Mtc\Coupons\Modifiers\FreeWorldwideDelivery::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Chart
    |--------------------------------------------------------------------------
    |
    | Chart to show dependent on the discount
    |
    */

    'chart' => [
        'enabled' => false,
        'class' => \Mtc\Coupons\Charts\Coupon::class,
        'step_size' => 100,
        'group_by' => [
            0 => 'Days',
            1 => 'Months',
            2 => 'Years'
        ]
    ]
];
