<?php

namespace Mtc\Coupons;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Class Restriction
 *
 * @package Mtc\Coupons
 */
class Restriction extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'coupon_restrictions';

    /**
     * @var array The attributes that are mass assignable.
     */
    protected $fillable = [
        'coupon_id',
        'discountable_id',
        'discountable_type',
        'exclude'
    ];

    /**
     * Cast attributes to specific types
     *
     * @var array
     */
    protected $casts = [
        'exclude' => 'boolean',
        'discountable_id' => 'integer',
        'discount_id' => 'integer'
    ];
    
    /**
     * Scope - ofCoupon()
     *
     * @param Builder $query Query to extend
     * @param mixed $coupon reference of coupon (allows int id, array or object)
     * @return Builder
     */
    public function scopeOfCoupon(Builder $query, $coupon)
    {
        return $query->where("coupon_id", id($coupon));
    }

    /**
     * Scope - excluded()
     *
     * @param Builder $query Query to extend
     * @param int $excluded whether condition is exclusive or inclusive
     * @return Builder
     */
    public function scopeExcluded(Builder $query, $excluded = 1)
    {
        return $query->where("exclude", $excluded);
    }

    /**
     * Relationship with discount restriction owner
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphTo
     */
    public function discountable()
    {
        return $this->morphTo('discountable');
    }

    /**
     * Define Eloquent relationship to coupon class
     * @return BelongsTo
     */
    public function coupon()
    {
        return $this->belongsTo(Coupon::class);
    }

}
