<?php

namespace Mtc\Coupons\Types;

use Illuminate\Support\Facades\App;
use Mtc\Coupons\Contracts\CouponRepositoryInterface;

/**
 * Class AmountOff
 * @package Mtc\Coupons\Types
 */
class AmountOff extends CouponTypeBase
{
    /**
     * Get Total Discounted Amount
     *
     * @return float
     */
    protected function getDiscountedAmount()
    {
        $discounted_amount = $this->applicable_items
            ->map(function ($item) {
                return $this->applyToItem($item);
            })
            ->sum();

        return round($discounted_amount, config('tax.price_calculation_precision', 3));
    }

    /**
     * Apply set amount discount to item
     *
     * @param $item
     * @return float|int
     */
    public function applyToItem($item)
    {
        return ($item->unit_price < $this->coupon->getModel()->value ? $item->unit_price : $this->coupon->getModel()->value) * $item->quantity;
    }

    /**
     * Get Discounted values for item line
     *
     * @param $coupon
     * @param $item
     * @return float
     */
    public function getDiscountedValues($coupon, $item)
    {
        $this->coupon = App::make(CouponRepositoryInterface::class);
        $this->coupon->setModel($coupon);
        return [
            'discounted_amount' =>  round($this->applyToItem($item), config('tax.price_calculation_precision', 3))
        ];
    }
}
